Ext.data.JsonP.sol_common_ix_services_GetDocumentsPreviewURLs({"tagname":"class","name":"sol.common.ix.services.GetDocumentsPreviewURLs","autodetected":{"aliases":true,"alternateClassNames":true,"extends":true,"mixins":true,"uses":true,"members":true,"code_type":true},"files":[{"filename":"sol.common.ix.services.GetDocumentsPreviewURLs.js","href":"sol.common.ix.services.GetDocumentsPreviewURLs.html#sol-common-ix-services-GetDocumentsPreviewURLs"}],"author":[{"tagname":"author","name":"ESt, ELO Digital Office GmbH","email":null}],"eloix":true,"requires":["sol.common.UserUtils","sol.common.ix.RfUtils","sol.common.ix.ServiceBase"],"aliases":{},"alternateClassNames":[],"extends":"sol.common.ix.ServiceBase","mixins":[],"uses":[],"members":[{"name":"documentId","tagname":"cfg","owner":"sol.common.ix.services.GetDocumentsPreviewURLs","id":"cfg-documentId","meta":{}},{"name":"documentIds","tagname":"cfg","owner":"sol.common.ix.services.GetDocumentsPreviewURLs","id":"cfg-documentIds","meta":{}},{"name":"endPage","tagname":"cfg","owner":"sol.common.ix.services.GetDocumentsPreviewURLs","id":"cfg-endPage","meta":{}},{"name":"flatten","tagname":"cfg","owner":"sol.common.ix.services.GetDocumentsPreviewURLs","id":"cfg-flatten","meta":{}},{"name":"objId","tagname":"cfg","owner":"sol.common.ix.services.GetDocumentsPreviewURLs","id":"cfg-objId","meta":{}},{"name":"objIds","tagname":"cfg","owner":"sol.common.ix.services.GetDocumentsPreviewURLs","id":"cfg-objIds","meta":{}},{"name":"previewSize","tagname":"cfg","owner":"sol.common.ix.services.GetDocumentsPreviewURLs","id":"cfg-previewSize","meta":{}},{"name":"processDocument","tagname":"cfg","owner":"sol.common.ix.services.GetDocumentsPreviewURLs","id":"cfg-processDocument","meta":{}},{"name":"renderAnnotations","tagname":"cfg","owner":"sol.common.ix.services.GetDocumentsPreviewURLs","id":"cfg-renderAnnotations","meta":{}},{"name":"renderAnnotationsData","tagname":"cfg","owner":"sol.common.ix.services.GetDocumentsPreviewURLs","id":"cfg-renderAnnotationsData","meta":{}},{"name":"renderAnnotationsOnly","tagname":"cfg","owner":"sol.common.ix.services.GetDocumentsPreviewURLs","id":"cfg-renderAnnotationsOnly","meta":{}},{"name":"requiredConfig","tagname":"cfg","owner":"sol.Base","id":"cfg-requiredConfig","meta":{"protected":true}},{"name":"startPage","tagname":"cfg","owner":"sol.common.ix.services.GetDocumentsPreviewURLs","id":"cfg-startPage","meta":{}},{"name":"$className","tagname":"property","owner":"sol.Base","id":"property-S-className","meta":{"protected":true}},{"name":"data","tagname":"property","owner":"sol.common.ix.ServiceBase","id":"property-data","meta":{}},{"name":"defaultPreviewSize","tagname":"property","owner":"sol.common.ix.services.GetDocumentsPreviewURLs","id":"property-defaultPreviewSize","meta":{}},{"name":"logger","tagname":"property","owner":"sol.common.ix.ServiceBase","id":"property-logger","meta":{"protected":true}},{"name":"previewSizes","tagname":"property","owner":"sol.common.ix.services.GetDocumentsPreviewURLs","id":"property-previewSizes","meta":{"private":true}},{"name":"$super","tagname":"method","owner":"sol.Base","id":"method-S-super","meta":{"private":true}},{"name":"PreviewImageInfoGenerator","tagname":"method","owner":"sol.common.ix.services.GetDocumentsPreviewURLs","id":"method-PreviewImageInfoGenerator","meta":{"private":true}},{"name":"addPreviewUrlsOf","tagname":"method","owner":"sol.common.ix.services.GetDocumentsPreviewURLs","id":"method-addPreviewUrlsOf","meta":{"private":true}},{"name":"buildPreviewImageInfo","tagname":"method","owner":"sol.common.ix.services.GetDocumentsPreviewURLs","id":"method-buildPreviewImageInfo","meta":{"private":true}},{"name":"checkMandatoryProperties","tagname":"method","owner":"sol.common.ix.ServiceBase","id":"method-checkMandatoryProperties","meta":{"protected":true}},{"name":"containsClassName","tagname":"method","owner":"sol.common.ix.ServiceBase","id":"method-containsClassName","meta":{}},{"name":"flattenActive","tagname":"method","owner":"sol.common.ix.services.GetDocumentsPreviewURLs","id":"method-flattenActive","meta":{"private":true}},{"name":"getPreviewURLs","tagname":"method","owner":"sol.common.ix.services.GetDocumentsPreviewURLs","id":"method-getPreviewURLs","meta":{"private":true}},{"name":"initialize","tagname":"method","owner":"sol.common.ix.ServiceBase","id":"method-initialize","meta":{"private":true}},{"name":"jsStr","tagname":"method","owner":"sol.common.ix.services.GetDocumentsPreviewURLs","id":"method-jsStr","meta":{"private":true}},{"name":"prefillMetadata","tagname":"method","owner":"sol.common.ix.ServiceBase","id":"method-prefillMetadata","meta":{"protected":true}},{"name":"process","tagname":"method","owner":"sol.common.ix.services.GetDocumentsPreviewURLs","id":"method-process","meta":{}},{"name":"RF_sol_common_service_GetDocumentsPreviewURLs","tagname":"method","owner":"sol.common.ix.services.GetDocumentsPreviewURLs","id":"static-method-RF_sol_common_service_GetDocumentsPreviewURLs","meta":{"static":true}}],"code_type":"ext_define","id":"class-sol.common.ix.services.GetDocumentsPreviewURLs","short_doc":"Retrieves preview urls for the specified id(s), which can be objIds or guids. ...","classIcon":"icon-class","superclasses":["sol.Base","sol.common.ix.ServiceBase"],"subclasses":[],"mixedInto":[],"parentMixins":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/sol.Base' rel='sol.Base' class='docClass'>sol.Base</a><div class='subclass '><a href='#!/api/sol.common.ix.ServiceBase' rel='sol.common.ix.ServiceBase' class='docClass'>sol.common.ix.ServiceBase</a><div class='subclass '><strong>sol.common.ix.services.GetDocumentsPreviewURLs</strong></div></div></div><h4>Requires</h4><div class='dependency'><a href='#!/api/sol.common.UserUtils' rel='sol.common.UserUtils' class='docClass'>sol.common.UserUtils</a></div><div class='dependency'><a href='#!/api/sol.common.ix.RfUtils' rel='sol.common.ix.RfUtils' class='docClass'>sol.common.ix.RfUtils</a></div><div class='dependency'><a href='#!/api/sol.common.ix.ServiceBase' rel='sol.common.ix.ServiceBase' class='docClass'>sol.common.ix.ServiceBase</a></div><h4>Files</h4><div class='dependency'><a href='source/sol.common.ix.services.GetDocumentsPreviewURLs.html#sol-common-ix-services-GetDocumentsPreviewURLs' target='_blank'>sol.common.ix.services.GetDocumentsPreviewURLs.js</a></div></pre><div class='doc-contents'><p>Retrieves preview urls for the specified id(s), which can be objIds or guids.</p>\n\n<h3>Examples</h3>\n\n<h4>Get a document's URL</h4>\n\n<pre><code>Call\n{\n  objId: \"(205E7844-175E-8A12-B83F-BED4A87EB996)\"\n}\nResult\n{\n  (205E7844-175E-8A12-B83F-BED4A87EB996): \"http://archive.dev.elo/ix-Solutions/ix?cmd=preview&amp;ticket=DDDD369F7EEA08E408C2DAA5F664AD12&amp;page=1&amp;size=131072&amp;notes=false&amp;doc=true&amp;slctn=false&amp;docid=(6C373A45-597F-75F2-934E-690A53177E7F)\"\n}\n</code></pre>\n\n<h4>Get URLs for multiple documents</h4>\n\n<p>The second document only has one single page. We use flatten, therefore the second document's URL is returned as a string.\nIf we would not use flatten, both properties would be an array.</p>\n\n<pre><code>Call\n{\n  objIds: [\n    \"(F2FAC205-7A40-180A-66B5-F580E678F041)\",\n    \"(205E7844-175E-8A12-B83F-BED4A87EB996)\"\n  ],\n  previewSize: \"tiny\",\n  startPage: 1,\n  endPage: 2,\n  flatten: true\n}\nResult\n{\n  (F2FAC205-7A40-180A-66B5-F580E678F041): [\n    \"http://archive.dev.elo/ix-Solutions/ix?cmd=preview&amp;ticket=DDDD369F7EEA08E408C2DAA5F664AD12&amp;page=1&amp;size=131072&amp;notes=false&amp;doc=true&amp;slctn=false&amp;docid=(B9464D83-5E03-31DF-46F4-3F2531C231B2)\",\n    \"http://archive.dev.elo/ix-Solutions/ix?cmd=preview&amp;ticket=DDDD369F7EEA08E408C2DAA5F664AD12&amp;page=2&amp;size=131072&amp;notes=false&amp;doc=true&amp;slctn=false&amp;docid=(B9464D83-5E03-31DF-46F4-3F2531C231B2)\",\n  ],\n  (205E7844-175E-8A12-B83F-BED4A87EB996): \"http://archive.dev.elo/ix-Solutions/ix?cmd=preview&amp;ticket=DDDD369F7EEA08E408C2DAA5F664AD12&amp;page=1&amp;size=131072&amp;notes=false&amp;doc=true&amp;slctn=false&amp;docid=(6C373A45-597F-75F2-934E-690A53177E7F)\"\n}\n</code></pre>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-documentId' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.GetDocumentsPreviewURLs'>sol.common.ix.services.GetDocumentsPreviewURLs</span><br/><a href='source/sol.common.ix.services.GetDocumentsPreviewURLs.html#sol-common-ix-services-GetDocumentsPreviewURLs-cfg-documentId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.GetDocumentsPreviewURLs-cfg-documentId' class='name expandable'>documentId</a> : String<span class=\"signature\"></span></div><div class='description'><div class='short'>(optional)\nAn objId or guid of a specific document version. ...</div><div class='long'><p>(optional)\nAn objId or guid of a specific document version. (parameter objId is ignored if this is defined)</p>\n</div></div></div><div id='cfg-documentIds' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.GetDocumentsPreviewURLs'>sol.common.ix.services.GetDocumentsPreviewURLs</span><br/><a href='source/sol.common.ix.services.GetDocumentsPreviewURLs.html#sol-common-ix-services-GetDocumentsPreviewURLs-cfg-documentIds' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.GetDocumentsPreviewURLs-cfg-documentIds' class='name expandable'>documentIds</a> : String[]<span class=\"signature\"></span></div><div class='description'><div class='short'>(optional)\nAn Array of objIds or guids of specific document versions. ...</div><div class='long'><p>(optional)\nAn Array of objIds or guids of specific document versions. (parameter objIds is ignored if this is defined)</p>\n</div></div></div><div id='cfg-endPage' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.GetDocumentsPreviewURLs'>sol.common.ix.services.GetDocumentsPreviewURLs</span><br/><a href='source/sol.common.ix.services.GetDocumentsPreviewURLs.html#sol-common-ix-services-GetDocumentsPreviewURLs-cfg-endPage' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.GetDocumentsPreviewURLs-cfg-endPage' class='name expandable'>endPage</a> : Number<span class=\"signature\"></span></div><div class='description'><div class='short'>(optional)\nInclude all pages up to page endPage in the preview. ...</div><div class='long'><p>(optional)\nInclude all pages up to page <code>endPage</code> in the preview.</p>\n<p>Defaults to: <code>1</code></p></div></div></div><div id='cfg-flatten' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.GetDocumentsPreviewURLs'>sol.common.ix.services.GetDocumentsPreviewURLs</span><br/><a href='source/sol.common.ix.services.GetDocumentsPreviewURLs.html#sol-common-ix-services-GetDocumentsPreviewURLs-cfg-flatten' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.GetDocumentsPreviewURLs-cfg-flatten' class='name expandable'>flatten</a> : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>(optional)\nIf startPage and endPage are defined, usually the urls for each page are returned in an array. ...</div><div class='long'><p>(optional)\nIf startPage and endPage are defined, usually the urls for each page are returned in an array.\nIf this option is set to true and there is only one page in the resulting preview, the service\nwill not return an array, but only a string.</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='cfg-objId' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.GetDocumentsPreviewURLs'>sol.common.ix.services.GetDocumentsPreviewURLs</span><br/><a href='source/sol.common.ix.services.GetDocumentsPreviewURLs.html#sol-common-ix-services-GetDocumentsPreviewURLs-cfg-objId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.GetDocumentsPreviewURLs-cfg-objId' class='name expandable'>objId</a> : String<span class=\"signature\"></span></div><div class='description'><div class='short'><p>(optional)\nAn objId or guid.</p>\n</div><div class='long'><p>(optional)\nAn objId or guid.</p>\n<p>Overrides: <a href=\"#!/api/sol.common.ix.ServiceBase-cfg-objId\" rel=\"sol.common.ix.ServiceBase-cfg-objId\" class=\"docClass\">sol.common.ix.ServiceBase.objId</a></p></div></div></div><div id='cfg-objIds' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.GetDocumentsPreviewURLs'>sol.common.ix.services.GetDocumentsPreviewURLs</span><br/><a href='source/sol.common.ix.services.GetDocumentsPreviewURLs.html#sol-common-ix-services-GetDocumentsPreviewURLs-cfg-objIds' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.GetDocumentsPreviewURLs-cfg-objIds' class='name expandable'>objIds</a> : String[]<span class=\"signature\"></span></div><div class='description'><div class='short'><p>(optional)\nAn Array of objIds or guids.</p>\n</div><div class='long'><p>(optional)\nAn Array of objIds or guids.</p>\n</div></div></div><div id='cfg-previewSize' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.GetDocumentsPreviewURLs'>sol.common.ix.services.GetDocumentsPreviewURLs</span><br/><a href='source/sol.common.ix.services.GetDocumentsPreviewURLs.html#sol-common-ix-services-GetDocumentsPreviewURLs-cfg-previewSize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.GetDocumentsPreviewURLs-cfg-previewSize' class='name expandable'>previewSize</a> : String|\"original\"|\"tiniest\"|\"tiny\"|\"medium\"|\"large\"<span class=\"signature\"></span></div><div class='description'><div class='short'>(optional)\nResizes the generated preview accordingly ...</div><div class='long'><p>(optional)\nResizes the generated preview accordingly</p>\n<p>Defaults to: <code>&quot;original&quot;</code></p></div></div></div><div id='cfg-processDocument' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.GetDocumentsPreviewURLs'>sol.common.ix.services.GetDocumentsPreviewURLs</span><br/><a href='source/sol.common.ix.services.GetDocumentsPreviewURLs.html#sol-common-ix-services-GetDocumentsPreviewURLs-cfg-processDocument' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.GetDocumentsPreviewURLs-cfg-processDocument' class='name expandable'>processDocument</a> : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>(optional)\nActivate processing (see JavaDoc) ...</div><div class='long'><p>(optional)\nActivate processing (see JavaDoc)</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='cfg-renderAnnotations' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.GetDocumentsPreviewURLs'>sol.common.ix.services.GetDocumentsPreviewURLs</span><br/><a href='source/sol.common.ix.services.GetDocumentsPreviewURLs.html#sol-common-ix-services-GetDocumentsPreviewURLs-cfg-renderAnnotations' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.GetDocumentsPreviewURLs-cfg-renderAnnotations' class='name expandable'>renderAnnotations</a> : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>(optional)\nRender annotations ...</div><div class='long'><p>(optional)\nRender annotations</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='cfg-renderAnnotationsData' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.GetDocumentsPreviewURLs'>sol.common.ix.services.GetDocumentsPreviewURLs</span><br/><a href='source/sol.common.ix.services.GetDocumentsPreviewURLs.html#sol-common-ix-services-GetDocumentsPreviewURLs-cfg-renderAnnotationsData' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.GetDocumentsPreviewURLs-cfg-renderAnnotationsData' class='name expandable'>renderAnnotationsData</a> : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>(optional)\nRender annotation data ...</div><div class='long'><p>(optional)\nRender annotation data</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='cfg-renderAnnotationsOnly' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.GetDocumentsPreviewURLs'>sol.common.ix.services.GetDocumentsPreviewURLs</span><br/><a href='source/sol.common.ix.services.GetDocumentsPreviewURLs.html#sol-common-ix-services-GetDocumentsPreviewURLs-cfg-renderAnnotationsOnly' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.GetDocumentsPreviewURLs-cfg-renderAnnotationsOnly' class='name expandable'>renderAnnotationsOnly</a> : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>(optional)\nOnly render Annotations ...</div><div class='long'><p>(optional)\nOnly render Annotations</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='cfg-requiredConfig' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-cfg-requiredConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-cfg-requiredConfig' class='name expandable'>requiredConfig</a> : Array<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>List of required config properties. ...</div><div class='long'><p>List of required config properties. <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a> throws an exception if one of the properties is null or undefined.</p>\n</div></div></div><div id='cfg-startPage' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.GetDocumentsPreviewURLs'>sol.common.ix.services.GetDocumentsPreviewURLs</span><br/><a href='source/sol.common.ix.services.GetDocumentsPreviewURLs.html#sol-common-ix-services-GetDocumentsPreviewURLs-cfg-startPage' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.GetDocumentsPreviewURLs-cfg-startPage' class='name expandable'>startPage</a> : Number<span class=\"signature\"></span></div><div class='description'><div class='short'>(optional)\nInclude all pages starting from startPage in the preview. ...</div><div class='long'><p>(optional)\nInclude all pages starting from <code>startPage</code> in the preview.</p>\n<p>Defaults to: <code>1</code></p></div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-S-className' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-S-className' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-S-className' class='name expandable'>$className</a> : Object<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>{String}\nname of the class including its namespace.</p>\n</div><div class='long'><p>{String}\nname of the class including its namespace.</p>\n</div></div></div><div id='property-data' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.ServiceBase' rel='sol.common.ix.ServiceBase' class='defined-in docClass'>sol.common.ix.ServiceBase</a><br/><a href='source/lib_sol.common.ix.ServiceBase.html#sol-common-ix-ServiceBase-property-data' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.ServiceBase-property-data' class='name expandable'>data</a> : Object<span class=\"signature\"></span></div><div class='description'><div class='short'><p>(optional)\nHas to be in a specific form (see <a href=\"#!/api/sol.common.SordUtils-method-updateSord\" rel=\"sol.common.SordUtils-method-updateSord\" class=\"docClass\">sol.common.SordUtils.updateSord</a>).</p>\n</div><div class='long'><p>(optional)\nHas to be in a specific form (see <a href=\"#!/api/sol.common.SordUtils-method-updateSord\" rel=\"sol.common.SordUtils-method-updateSord\" class=\"docClass\">sol.common.SordUtils.updateSord</a>).</p>\n</div></div></div><div id='property-defaultPreviewSize' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.GetDocumentsPreviewURLs'>sol.common.ix.services.GetDocumentsPreviewURLs</span><br/><a href='source/sol.common.ix.services.GetDocumentsPreviewURLs.html#sol-common-ix-services-GetDocumentsPreviewURLs-property-defaultPreviewSize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.GetDocumentsPreviewURLs-property-defaultPreviewSize' class='name expandable'>defaultPreviewSize</a> : String<span class=\"signature\"></span></div><div class='description'><div class='short'>If no previewSize is defined. ...</div><div class='long'><p>If no previewSize is defined. This value is used.</p>\n<p>Defaults to: <code>&quot;original&quot;</code></p></div></div></div><div id='property-logger' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.ServiceBase' rel='sol.common.ix.ServiceBase' class='defined-in docClass'>sol.common.ix.ServiceBase</a><br/><a href='source/lib_sol.common.ix.ServiceBase.html#sol-common-ix-ServiceBase-property-logger' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.ServiceBase-property-logger' class='name expandable'>logger</a> : <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a><span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>The logger for the service</p>\n</div><div class='long'><p>The logger for the service</p>\n<p>Overrides: <a href=\"#!/api/sol.Base-property-logger\" rel=\"sol.Base-property-logger\" class=\"docClass\">sol.Base.logger</a></p></div></div></div><div id='property-previewSizes' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.GetDocumentsPreviewURLs'>sol.common.ix.services.GetDocumentsPreviewURLs</span><br/><a href='source/sol.common.ix.services.GetDocumentsPreviewURLs.html#sol-common-ix-services-GetDocumentsPreviewURLs-property-previewSizes' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.GetDocumentsPreviewURLs-property-previewSizes' class='name expandable'>previewSizes</a> : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'><p>mapping between previewSize and PreviewImageInfoC constant values</p>\n</div><div class='long'><p>mapping between previewSize and PreviewImageInfoC constant values</p>\n</div></div></div></div></div><div class='members-section'><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Instance methods</h3><div id='method-S-super' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-S-super' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-S-super' class='name expandable'>$super</a>( <span class='pre'>superClassName, functionName, arguments</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Calls a function of a superclass thanks to its name. ...</div><div class='long'><p>Calls a function of a superclass thanks to its name. Superclass must be part of the calling objects class hierarchy.</p>\n\n<p><b>Please note that calling superclass functions might lead to an infinitive loop if misused. Please validate that none class other than the classes superclass is passed as the superclass parent.</b></p>\n\n<pre><code>me.$super(superClassName, functionName, attributesArray);\n</code></pre>\n\n<p>A basic example of the initialize-function will look as followed.</p>\n\n<pre><code>me.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", [config]);\nme.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", arguments);\n</code></pre>\n\n<p>A word on performance: The superclass name must be passed since the js rhino engine does not allow accessing the caller of the callee due to performance reasons.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>superClassName</span> : String<div class='sub-desc'><p>name of the super class.</p>\n</div></li><li><span class='pre'>functionName</span> : String<div class='sub-desc'><p>name of the function that should be called.</p>\n</div></li><li><span class='pre'>arguments</span> : Object[]<div class='sub-desc'><p>list of arguments that should be passed to the function.</p>\n</div></li></ul></div></div></div><div id='method-PreviewImageInfoGenerator' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.GetDocumentsPreviewURLs'>sol.common.ix.services.GetDocumentsPreviewURLs</span><br/><a href='source/sol.common.ix.services.GetDocumentsPreviewURLs.html#sol-common-ix-services-GetDocumentsPreviewURLs-method-PreviewImageInfoGenerator' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.GetDocumentsPreviewURLs-method-PreviewImageInfoGenerator' class='name expandable'>PreviewImageInfoGenerator</a>( <span class='pre'>classContext</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Returns a PreviewImageInfoGenerator ...</div><div class='long'><p>Returns a PreviewImageInfoGenerator</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>classContext</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-addPreviewUrlsOf' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.GetDocumentsPreviewURLs'>sol.common.ix.services.GetDocumentsPreviewURLs</span><br/><a href='source/sol.common.ix.services.GetDocumentsPreviewURLs.html#sol-common-ix-services-GetDocumentsPreviewURLs-method-addPreviewUrlsOf' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.GetDocumentsPreviewURLs-method-addPreviewUrlsOf' class='name expandable'>addPreviewUrlsOf</a>( <span class='pre'>idProperty, flatten, pii, acc, id</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Adds the urls of the preview of document id. ...</div><div class='long'><p>Adds the urls of the preview of document <code>id</code>. For usage in Array.reduce()</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>idProperty</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>flatten</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>pii</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>acc</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>id</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-buildPreviewImageInfo' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.GetDocumentsPreviewURLs'>sol.common.ix.services.GetDocumentsPreviewURLs</span><br/><a href='source/sol.common.ix.services.GetDocumentsPreviewURLs.html#sol-common-ix-services-GetDocumentsPreviewURLs-method-buildPreviewImageInfo' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.GetDocumentsPreviewURLs-method-buildPreviewImageInfo' class='name expandable'>buildPreviewImageInfo</a>( <span class='pre'>opts</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Builds a PreviewImageInfo Java Object for checkoutPreviewImageURLs ...</div><div class='long'><p>Builds a PreviewImageInfo Java Object for checkoutPreviewImageURLs</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>opts</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-checkMandatoryProperties' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.ServiceBase' rel='sol.common.ix.ServiceBase' class='defined-in docClass'>sol.common.ix.ServiceBase</a><br/><a href='source/lib_sol.common.ix.ServiceBase.html#sol-common-ix-ServiceBase-method-checkMandatoryProperties' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.ServiceBase-method-checkMandatoryProperties' class='name expandable'>checkMandatoryProperties</a>( <span class='pre'></span> )<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Checks if all mandatory properties have been set. ...</div><div class='long'><p>Checks if all mandatory properties have been set.</p>\n</div></div></div><div id='method-containsClassName' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.ServiceBase' rel='sol.common.ix.ServiceBase' class='defined-in docClass'>sol.common.ix.ServiceBase</a><br/><a href='source/lib_sol.common.ix.ServiceBase.html#sol-common-ix-ServiceBase-method-containsClassName' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.ServiceBase-method-containsClassName' class='name expandable'>containsClassName</a>( <span class='pre'>classNames</span> ) : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>Checks wether an array contains the class name ...</div><div class='long'><p>Checks wether an array contains the class name</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>classNames</span> : Array<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-flattenActive' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.GetDocumentsPreviewURLs'>sol.common.ix.services.GetDocumentsPreviewURLs</span><br/><a href='source/sol.common.ix.services.GetDocumentsPreviewURLs.html#sol-common-ix-services-GetDocumentsPreviewURLs-method-flattenActive' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.GetDocumentsPreviewURLs-method-flattenActive' class='name expandable'>flattenActive</a>( <span class='pre'>opts</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Determines if the flatten option should be active ...</div><div class='long'><p>Determines if the flatten option should be active</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>opts</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-getPreviewURLs' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.GetDocumentsPreviewURLs'>sol.common.ix.services.GetDocumentsPreviewURLs</span><br/><a href='source/sol.common.ix.services.GetDocumentsPreviewURLs.html#sol-common-ix-services-GetDocumentsPreviewURLs-method-getPreviewURLs' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.GetDocumentsPreviewURLs-method-getPreviewURLs' class='name expandable'>getPreviewURLs</a>( <span class='pre'>pii, id</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>retrieves available urls for the preview of the document id defined by the PreviewImageInfo pii ...</div><div class='long'><p>retrieves available urls for the preview of the document <code>id</code> defined by the PreviewImageInfo <code>pii</code></p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>pii</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>id</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-initialize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.ServiceBase' rel='sol.common.ix.ServiceBase' class='defined-in docClass'>sol.common.ix.ServiceBase</a><br/><a href='source/lib_sol.common.ix.ServiceBase.html#sol-common-ix-ServiceBase-method-initialize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.ServiceBase-method-initialize' class='name expandable'>initialize</a>( <span class='pre'>config</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Initialize class. ...</div><div class='long'><p>Initialize class.\nThis function is called after the class was instantiated.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>parameters as defined. See documentation for more details.</p>\n</div></li></ul><p>Overrides: <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a></p></div></div></div><div id='method-jsStr' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.GetDocumentsPreviewURLs'>sol.common.ix.services.GetDocumentsPreviewURLs</span><br/><a href='source/sol.common.ix.services.GetDocumentsPreviewURLs.html#sol-common-ix-services-GetDocumentsPreviewURLs-method-jsStr' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.GetDocumentsPreviewURLs-method-jsStr' class='name expandable'>jsStr</a>( <span class='pre'>s</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>for usage in Array.map() ...</div><div class='long'><p>for usage in Array.map()</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>s</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-prefillMetadata' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.ServiceBase' rel='sol.common.ix.ServiceBase' class='defined-in docClass'>sol.common.ix.ServiceBase</a><br/><a href='source/lib_sol.common.ix.ServiceBase.html#sol-common-ix-ServiceBase-method-prefillMetadata' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.ServiceBase-method-prefillMetadata' class='name expandable'>prefillMetadata</a>( <span class='pre'>objId</span> )<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Initializes the metadata of an element (defined by objId) from the internal data object. ...</div><div class='long'><p>Initializes the metadata of an element (defined by <code>objId</code>) from the internal <code>data</code> object.</p>\n\n<p>The <code>data</code> property has to be in a specific <a href=\"#!/api/sol.common.ix.ServiceBase-property-data\" rel=\"sol.common.ix.ServiceBase-property-data\" class=\"docClass\">form</a>.\nIf there is no data object no prefilling will be performed.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>objId</span> : String<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-process' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.GetDocumentsPreviewURLs'>sol.common.ix.services.GetDocumentsPreviewURLs</span><br/><a href='source/sol.common.ix.services.GetDocumentsPreviewURLs.html#sol-common-ix-services-GetDocumentsPreviewURLs-method-process' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.GetDocumentsPreviewURLs-method-process' class='name expandable'>process</a>( <span class='pre'></span> ) : Object<span class=\"signature\"></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>return Object containing all URLs mapped to all Ids</p>\n<ul><li><span class='pre'>propertyName</span> : String<div class='sub-desc'><p>name of the passed id</p>\n</div></li><li><span class='pre'>propertyValue</span> : String|String[]<div class='sub-desc'><p>URLs</p>\n</div></li></ul></div></li></ul><p>Overrides: <a href=\"#!/api/sol.common.ix.ServiceBase-method-process\" rel=\"sol.common.ix.ServiceBase-method-process\" class=\"docClass\">sol.common.ix.ServiceBase.process</a></p></div></div></div></div><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Static methods</h3><div id='static-method-RF_sol_common_service_GetDocumentsPreviewURLs' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.GetDocumentsPreviewURLs'>sol.common.ix.services.GetDocumentsPreviewURLs</span><br/><a href='source/sol.common.ix.services.GetDocumentsPreviewURLs.html#sol-common-ix-services-GetDocumentsPreviewURLs-static-method-RF_sol_common_service_GetDocumentsPreviewURLs' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.GetDocumentsPreviewURLs-static-method-RF_sol_common_service_GetDocumentsPreviewURLs' class='name expandable'>RF_sol_common_service_GetDocumentsPreviewURLs</a>( <span class='pre'>Execution, args</span> )<span class=\"signature\"><span class='static' >static</span></span></div><div class='description'><div class='short'>This service can be called from an application by invoking the API function \"executeRegisteredFunction\" or by using\ns...</div><div class='long'><p>This service can be called from an application by invoking the API function \"executeRegisteredFunction\" or by using\n<a href=\"#!/api/sol.common.IxUtils-method-execute\" rel=\"sol.common.IxUtils-method-execute\" class=\"docClass\">sol.common.IxUtils.execute</a> which internally handles the Any-Object conversion.</p>\n\n<p>All configuration params should be passed as a configuration object to the args param.</p>\n\n<pre><code><a href=\"#!/api/sol.common.IxUtils-method-execute\" rel=\"sol.common.IxUtils-method-execute\" class=\"docClass\">sol.common.IxUtils.execute</a>('RF_ServiceBaseName', {\n  configParam1: 'myParam'\n});\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>Execution</span> : de.elo.ix.client.IXServerEventsContext<div class='sub-desc'><p>context</p>\n</div></li><li><span class='pre'>args</span> : Object<div class='sub-desc'><p>Argument array sent by the client application.</p>\n</div></li></ul></div></div></div></div></div></div></div>","meta":{"eloix":true}});